/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.model;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.opsupport.client.ActionOrScript;
import hec.rss.plugins.opsupport.client.OpSupportPlotLine;
import hec.rss.plugins.opsupport.client.OsiTableProperties;
import hec.rss.plugins.opsupport.client.OsiTableProperty;
import hec.rss.plugins.opsupport.model.OSVariableTSRef;
import hec.rss.plugins.opsupport.model.OpSupportActionsScripts;
import hec.rss.plugins.opsupport.model.OpSupportConfig;
import hec.rss.plugins.opsupport.model.OpSupportObject;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import hec.rss.plugins.opsupport.model.OpSupportTimeSeriesDataSet;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import rma.services.ServiceLookup;
import rma.services.tz.TimeZoneDisplayService;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class OpSupportModelVariable
extends NamedType
implements OpSupportObject {
    public static final String TSTYPE_PER_AVER = "PER-AVER";
    public static final String TSTYPE_INST_VAL = "INST-VAL";
    public static final int OPVAR_TYPE_HEADWATER = 0;
    public static final int OPVAR_TYPE_LOCAL = 1;
    public static final int OPVAR_TYPE_RELEASE = 2;
    public static final int OPVAR_TYPE_COMPUTED = 3;
    public static final int OPVAR_TYPE_ELEVTAR = 4;
    public static final int OPVAR_TYPE_EXTERNTS = 5;
    public static final int OPVAR_TYPE_DIVERSION = 6;
    public static String[] OPVAR_TYPE_STRARRAY = new String[]{"Headwater Inflow", "Local Inflow", "Reservoir Release", "Computed Parameter", "Elevation Target", "External Time Series", "Diversion Override"};
    public static final String OPVAR_OBSTS_NAME = "Observed";
    public static final String OPVAR_EDITTS_NAME = "Editable";
    public static final String OPVAR_COMPTS_NAME = "Computed";
    public static final String OPVAR_OVRDTS_NAME = "Override";
    public static final String OPVAR_INFLTS_NAME = "Inflow";
    public static final String OPVAR_RAWTS_NAME = "Raw";
    public static final int OPVAR_OBSTS_ID = 0;
    public static final int OPVAR_EDITTS_ID = 1;
    public static final int OPVAR_COMPTS_ID = 2;
    public static final int OPVAR_OVRDTS_ID = 3;
    public static final int OPVAR_INFLTS_ID = 4;
    public static final int OPVAR_SUPTS_ID = 5;
    public static final int OPVAR_RAWTS_ID = 6;
    public static final int OPVAR_RECESS_OPT1 = 0;
    public static final int OPVAR_RECESS_OPT2 = 1;
    public static final int TESTID_ISOBS = 0;
    public static final int TESTID_ISEDITABLE = 1;
    public static final int TESTID_ISCOMPUTED = 2;
    public static final int TESTID_ISOVRD = 3;
    public static final int TESTID_LE_MINLIM = 10;
    public static final int TESTID_GE_MAXLIM = 11;
    public static final int TESTID_ISVALID = 12;
    public static final int TESTID_LRGST_VAL = 13;
    public static final int TESTID_SMLST_VAL = 14;
    public static final int TESTID_IN_LOOKBACK = 15;
    public static final int ELEM_TYPE_JUNC = 0;
    public static final int ELEM_TYPE_RES = 1;
    public static final int ELEM_TYPE_RCH = 2;
    public static final int ELEM_TYPE_DIV = 3;
    public static String[] ELEM_TYPE_STRARRAY = new String[]{"Junction", "Reservoir", "Reach", "Diversion"};
    public static final String[] ELEM_TYPE_CLASSSTR = new String[]{"hec.rss.model.JunctionElement", "hec.rss.model.ReservoirElement", "hec.rss.model.ReachElement", "hec.rss.model.DiversionElement"};
    public static String[] RECESS_OPT_STRARRAY = new String[]{"Method 1: Q[t]=Q[t-1]/R, t in days", "Method 2: Q[t]=Q[t0]*exp(-R*(t-t0)), t in days"};
    private int _varType = -1;
    private OSVariableTSRef _observedTS;
    private OSVariableTSRef _editableTS;
    private OSVariableTSRef _computedTS;
    private OSVariableTSRef _overrideTS;
    private OSVariableTSRef _inflowTS;
    private OSVariableTSRef _rawTS;
    private double _maxLimit = Double.NEGATIVE_INFINITY;
    private double _minLimit = Double.NEGATIVE_INFINITY;
    private int _recessionMethod = 0;
    private double _recessionConst = 0.95;
    private int _timeShiftSteps = 0;
    private String _localFlowName;
    private String _releaseName;
    private transient OpSupportTabConfig a;
    private OpSupportActionsScripts _actionsScriptsList = new OpSupportActionsScripts(false);
    private int _elementType = -1;
    private Element _element;
    private String _elemName;
    private int _elemId = -1;
    private List<OSVariableTSRef> _supportingTSRefList;
    private double _maxRecessPeriod = Double.NEGATIVE_INFINITY;
    private int _viewport = 0;

    public OpSupportModelVariable(OpSupportTabConfig opSupportTabConfig, String string) {
        super(string);
        this._observedTS = new OSVariableTSRef(this, OPVAR_OBSTS_NAME, 0);
        this._editableTS = new OSVariableTSRef(this, OPVAR_EDITTS_NAME, 1);
        this._computedTS = new OSVariableTSRef(this, OPVAR_COMPTS_NAME, 2);
        this._overrideTS = new OSVariableTSRef(this, OPVAR_OVRDTS_NAME, 3);
        this._inflowTS = new OSVariableTSRef(this, OPVAR_INFLTS_NAME, 4);
        this._rawTS = new OSVariableTSRef(this, OPVAR_RAWTS_NAME, 6);
        this._supportingTSRefList = new ArrayList<OSVariableTSRef>();
        this.a = opSupportTabConfig;
    }

    public OpSupportModelVariable() {
    }

    public OpSupportConfig getOSConfig() {
        return this.a.getOSConfig();
    }

    @Override
    public List<ActionOrScript> getListNoHierarchy() {
        return this._actionsScriptsList.getList();
    }

    public List<ActionOrScript> getListHierarchy() {
        if (this._actionsScriptsList.noActionsValue()) {
            return new ArrayList<ActionOrScript>(0);
        }
        List<ActionOrScript> list = this._actionsScriptsList.getList();
        if (list.isEmpty()) {
            return this.a.getListHierarchy();
        }
        return list;
    }

    public void setList(List<ActionOrScript> list) {
        this._actionsScriptsList.setList(list);
    }

    public void resetAndAddActionsOrScriptsList(List<ActionOrScript> list) {
        this._actionsScriptsList = new OpSupportActionsScripts(false);
        this._actionsScriptsList.getList().addAll(list);
    }

    @Override
    public OpSupportActionsScripts getActionsScripts() {
        return this._actionsScriptsList;
    }

    @Override
    public void moveObject(ActionOrScript actionOrScript, boolean bl) {
        this._actionsScriptsList.moveObjectInList(actionOrScript, bl);
    }

    @Override
    public void addObject(ActionOrScript actionOrScript) {
        this._actionsScriptsList.addObject(actionOrScript);
    }

    @Override
    public void removeObject(ActionOrScript actionOrScript) {
        this._actionsScriptsList.removeObject(actionOrScript);
    }

    @Override
    public void resetActions() {
        this._actionsScriptsList.resetList();
    }

    @Override
    public void clearActions() {
        this._actionsScriptsList.clearList();
    }

    @Override
    public void setActionsEnabled(boolean bl) {
        this._actionsScriptsList.setNoActionsValue(!bl);
    }

    @Override
    public boolean getNoActionValue() {
        return this._actionsScriptsList.noActionsValue();
    }

    @Override
    public void setNoActionValue(boolean bl) {
        this._actionsScriptsList.setNoActionsValue(bl);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl && this.a != null) {
            this.a.setModified(bl);
        }
    }

    public OpSupportModelVariable clone() {
        try {
            OpSupportModelVariable opSupportModelVariable = (OpSupportModelVariable)super.clone();
            ((OpSupportModelVariable)super.clone())._name = new String(this._name);
            if (this._observedTS != null) {
                opSupportModelVariable._observedTS = this._observedTS.clone();
            }
            if (this._editableTS != null) {
                opSupportModelVariable._editableTS = this._editableTS.clone();
            }
            if (this._computedTS != null) {
                opSupportModelVariable._computedTS = this._computedTS.clone();
            }
            if (this._overrideTS != null) {
                opSupportModelVariable._overrideTS = this._overrideTS.clone();
            }
            if (this._inflowTS != null) {
                opSupportModelVariable._inflowTS = this._inflowTS.clone();
            }
            if (this._rawTS != null) {
                opSupportModelVariable._rawTS = this._rawTS.clone();
            }
            if (this._supportingTSRefList != null) {
                opSupportModelVariable._supportingTSRefList = new ArrayList<OSVariableTSRef>();
                for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                    opSupportModelVariable._supportingTSRefList.add(oSVariableTSRef.clone());
                }
            }
            opSupportModelVariable._maxLimit = this._maxLimit;
            opSupportModelVariable._minLimit = this._minLimit;
            opSupportModelVariable._recessionConst = this._recessionConst;
            opSupportModelVariable._maxRecessPeriod = this._maxRecessPeriod;
            opSupportModelVariable._timeShiftSteps = this._timeShiftSteps;
            return opSupportModelVariable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("OpSupportTabConfig.clone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public void read(BufferedReader bufferedReader) throws IOException {
        Object object = bufferedReader.readLine();
        while (object != null) {
            if (((String)object).length() == 0) {
                object = bufferedReader.readLine();
                continue;
            }
            String string = RMAIO.getType((String)object, (String)":");
            String string2 = RMAIO.getParam((String)object, (String)":");
            if (string.equals("OSModelVariableEnd")) break;
            if (string.equals("ElementType")) {
                this._elementType = Integer.parseInt(string2);
            } else if (string.equals("ElementID")) {
                this._elemId = Integer.parseInt(string2);
            } else if (string.equals("ElementName")) {
                this._elemName = string2;
            } else if (string.equals("VariableType")) {
                this._varType = Integer.parseInt(string2);
            } else if (string.equals("LocalFlowName")) {
                this._localFlowName = string2;
            } else if (string.equals("ReleaseName")) {
                this._releaseName = string2;
            } else if (string.equals("OSVariableTSRef")) {
                if (OPVAR_OBSTS_NAME.equals(string2)) {
                    this._observedTS = new OSVariableTSRef(this, string2, 0);
                    this._observedTS.read(bufferedReader);
                } else if (OPVAR_EDITTS_NAME.equals(string2)) {
                    this._editableTS = new OSVariableTSRef(this, string2, 1);
                    this._editableTS.read(bufferedReader);
                } else if (OPVAR_COMPTS_NAME.equals(string2)) {
                    this._computedTS = new OSVariableTSRef(this, string2, 2);
                    this._computedTS.read(bufferedReader);
                } else if (OPVAR_OVRDTS_NAME.equals(string2)) {
                    this._overrideTS = new OSVariableTSRef(this, string2, 3);
                    this._overrideTS.read(bufferedReader);
                } else if (OPVAR_INFLTS_NAME.equals(string2)) {
                    this._inflowTS = new OSVariableTSRef(this, string2, 4);
                    this._inflowTS.read(bufferedReader);
                } else if (OPVAR_RAWTS_NAME.equals(string2)) {
                    this._rawTS = new OSVariableTSRef(this, string2, 6);
                    this._rawTS.read(bufferedReader);
                }
            } else if (string.equals("SupportingTSRef")) {
                if (this._supportingTSRefList == null) {
                    this._supportingTSRefList = new ArrayList<OSVariableTSRef>();
                }
                object = new OSVariableTSRef(this, string2, 2);
                ((OSVariableTSRef)object).read(bufferedReader);
                this._supportingTSRefList.add((OSVariableTSRef)object);
            } else if (string.equals("MaxLimit")) {
                this._maxLimit = Double.parseDouble(string2);
            } else if (string.equals("MinLimit")) {
                this._minLimit = Double.parseDouble(string2);
            } else if (string.equals("RecessionMethod")) {
                this._recessionMethod = Integer.parseInt(string2);
            } else if (string.equals("RecessionConst")) {
                this._recessionConst = Double.parseDouble(string2);
            } else if (string.equals("MaxRecessPeriod")) {
                this._maxRecessPeriod = Double.parseDouble(string2);
            } else if (string.equals("TimeStepShift")) {
                this._timeShiftSteps = Integer.parseInt(string2);
            } else if (string.equals("Viewport")) {
                this._viewport = Integer.parseInt(string2);
            } else if (((String)object).equals("ActionsBegin")) {
                this._actionsScriptsList.readIn(bufferedReader);
            }
            object = bufferedReader.readLine();
        }
        if (this._varType == 0) {
            this._varType = 1;
        }
        this.setModified(false);
    }

    public void write(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ElementType:" + Integer.toString(this._elementType)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ElementID:" + Integer.toString(this._elemId)));
        if (this._elemName != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ElementName:" + this._elemName));
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("VariableType:" + Integer.toString(this._varType)));
        if (this._localFlowName != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("LocalFlowName:" + this._localFlowName));
        }
        if (this._releaseName != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ReleaseName:" + this._releaseName));
        }
        if (this._observedTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._observedTS.getName()));
            this._observedTS.write(bufferedWriter);
        }
        if (this._editableTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._editableTS.getName()));
            this._editableTS.write(bufferedWriter);
        }
        if (this._computedTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._computedTS.getName()));
            this._computedTS.write(bufferedWriter);
        }
        if (this._overrideTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._overrideTS.getName()));
            this._overrideTS.write(bufferedWriter);
        }
        if (this._inflowTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._inflowTS.getName()));
            this._inflowTS.write(bufferedWriter);
        }
        if (this._rawTS != null) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRef:" + this._rawTS.getName()));
            this._rawTS.write(bufferedWriter);
        }
        if (this._supportingTSRefList != null) {
            for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SupportingTSRef:" + oSVariableTSRef.getName()));
                oSVariableTSRef.write(bufferedWriter);
            }
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MaxLimit:" + Double.toString(this._maxLimit)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MinLimit:" + Double.toString(this._minLimit)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RecessionMethod:" + Integer.toString(this._recessionMethod)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("RecessionConst:" + Double.toString(this._recessionConst)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("MaxRecessPeriod:" + Double.toString(this._maxRecessPeriod)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TimeStepShift:" + Integer.toString(this._timeShiftSteps)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Viewport:" + Integer.toString(this._viewport)));
        this._actionsScriptsList.writeOut(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSModelVariableEnd:" + this.getName()));
        this.setModified(false);
    }

    public void setElementType(int n) {
        if (n < 0 || n >= ELEM_TYPE_STRARRAY.length) {
            return;
        }
        this._elementType = n;
    }

    public int getElementType() {
        this.getElement();
        return this._elementType;
    }

    public void setElement(Element element) {
        this._element = element;
        if (element != null) {
            this._elementType = -1;
            if (element instanceof JunctionElement) {
                this._elementType = 0;
            } else if (element instanceof ReservoirElement) {
                this._elementType = 1;
            } else if (element instanceof ReachElement) {
                this._elementType = 2;
            } else if (element instanceof DiversionElement) {
                this._elementType = 3;
            }
            this._elemName = element.getName();
            this._elemId = element.getIndex();
            return;
        }
        this._elementType = -1;
        this._elemName = null;
        this._elemId = -1;
    }

    public Element getElement() {
        if (this._element != null) {
            return this._element;
        }
        JunctionElement junctionElement = null;
        if (this.a == null) {
            return null;
        }
        RssSystem rssSystem = this.a.getOsConfig().getRssSystem();
        if (rssSystem == null) {
            return null;
        }
        if (this._elemName != null) {
            switch (this._elementType) {
                case 0: {
                    junctionElement = rssSystem.findJunction(this._elemName);
                    break;
                }
                case 1: {
                    junctionElement = rssSystem.findReservoir(this._elemName);
                    break;
                }
                case 2: {
                    junctionElement = rssSystem.findReach(this._elemName);
                    break;
                }
                case 3: {
                    junctionElement = rssSystem.findDiversion(this._elemName);
                }
            }
        }
        if (junctionElement == null && this._elemId >= 0) {
            junctionElement = rssSystem.getElement(this._elemId);
        }
        if (junctionElement == null) {
            junctionElement = this.getElement(1);
            if (junctionElement == null) {
                junctionElement = this.getElement(3);
            }
            if (junctionElement == null) {
                junctionElement = this.getElement(2);
            }
        }
        if (junctionElement != null) {
            this.setElement((Element)junctionElement);
        }
        return junctionElement;
    }

    public void setLocalFlowName(String string) {
        this._localFlowName = string;
    }

    public String getLocalFlowName() {
        return this._localFlowName;
    }

    public void setReleaseName(String string) {
        this._releaseName = string;
    }

    public String getReleaseName() {
        return this._releaseName;
    }

    public void setVarType(int n) {
        this._varType = n;
    }

    public int getVarType() {
        return this._varType;
    }

    public double getRecessionConst() {
        return this._recessionConst;
    }

    public void setRecessionConst(double d) {
        this._recessionConst = d;
    }

    public int getRecessionMethod() {
        return this._recessionMethod;
    }

    public void setRecessionMethod(int n) {
        this._recessionMethod = n;
    }

    public int getTimeShift() {
        return this._timeShiftSteps;
    }

    public void setTimeShift(int n) {
        this._timeShiftSteps = n;
    }

    public String getTSTextName(int n) {
        OSVariableTSRef oSVariableTSRef = null;
        switch (n) {
            case 0: {
                oSVariableTSRef = this._observedTS;
                break;
            }
            case 1: {
                oSVariableTSRef = this._editableTS;
                break;
            }
            case 2: {
                oSVariableTSRef = this._computedTS;
                break;
            }
            case 3: {
                oSVariableTSRef = this._overrideTS;
                break;
            }
            case 4: {
                oSVariableTSRef = this._inflowTS;
                break;
            }
            case 6: {
                oSVariableTSRef = this._rawTS;
            }
        }
        if (oSVariableTSRef == null) {
            return "";
        }
        return oSVariableTSRef.getTSTextName(this.a.getOsConfig().getRssSystem());
    }

    public void getSupportingPlotTSRecords(List<OpSupportPlotLine> list, G2dLineProperties object) {
        TSRecord tSRecord;
        switch (this._varType) {
            case 1: {
                this.addLimitPlotObj(list, this._editableTS.getTSRecord(), "", null, this._viewport);
                if (object == null) break;
                this.addPlotObj(list, this._rawTS.getTSRecord(), "", null, this._viewport, (G2dLineProperties)object, null);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                tSRecord = this._computedTS.getTSRecord();
                if (tSRecord != null) {
                    this.addLimitPlotObj(list, tSRecord, "", null, this._viewport);
                    this.addPlotObj(list, tSRecord, "", null, this._viewport, null, null);
                } else {
                    System.out.println("Failed to load computed time series for " + this.getName());
                }
                if (object == null) break;
                OpSupportModelVariable opSupportModelVariable = this;
                TimeSeriesContainer timeSeriesContainer = opSupportModelVariable.buildOverrideTimeSeriesContainer(opSupportModelVariable._rawTS, "", null);
                if (timeSeriesContainer != null) {
                    OpSupportTimeSeriesDataSet object2 = new OpSupportTimeSeriesDataSet(timeSeriesContainer);
                    object2.setDefaultMaxYValue(Double.NEGATIVE_INFINITY);
                    object2.setDefaultMinYValue(Double.NEGATIVE_INFINITY);
                    object2.setDefaultMinYRangeFac(0.01);
                    list.add(new OpSupportPlotLine(this._viewport, (G2dObject)object2, (G2dLineProperties)object));
                    break;
                }
                System.out.println("Failed to load override time series for " + this.getName());
                break;
            }
            case 3: {
                this.addLimitPlotObj(list, this._computedTS.getTSRecord(), "", null, this._viewport);
                this.addPlotObj(list, this._computedTS.getTSRecord(), "", null, this._viewport, null, null);
                this.addPlotObj(list, this._observedTS.getTSRecord(), "OBS", "OBS", this._viewport, null, null);
            }
        }
        if (this._supportingTSRefList != null) {
            tSRecord = this.a != null ? this.a.getOsConfig() : null;
            for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                if (oSVariableTSRef.getTSRecord() == null) continue;
                object = oSVariableTSRef.getName();
                object = tSRecord != null ? tSRecord.getLineProperties((String)object) : null;
                String string = null;
                if (oSVariableTSRef.getTypeID() == 3) {
                    string = oSVariableTSRef.getTimeSeriesName();
                }
                this.addPlotObj(list, oSVariableTSRef.getTSRecord(), "", null, oSVariableTSRef.getViewport(), (G2dLineProperties)object, string);
            }
        }
    }

    public TimeSeriesContainer getEditableTSContainer() {
        TimeSeriesContainer timeSeriesContainer = null;
        switch (this._varType) {
            case 1: {
                OpSupportModelVariable opSupportModelVariable = this;
                timeSeriesContainer = opSupportModelVariable.buildTimeSeriesContainer(opSupportModelVariable._editableTS.getTSRecord(), "Rev", null);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                OpSupportModelVariable opSupportModelVariable = this;
                timeSeriesContainer = opSupportModelVariable.buildOverrideTimeSeriesContainer(opSupportModelVariable._overrideTS, "Rev", null);
            }
        }
        return timeSeriesContainer;
    }

    public TimeSeriesContainer getRawTSContainer() {
        TimeSeriesContainer timeSeriesContainer = null;
        switch (this._varType) {
            case 1: {
                OpSupportModelVariable opSupportModelVariable = this;
                timeSeriesContainer = opSupportModelVariable.buildTimeSeriesContainer(opSupportModelVariable._rawTS.getTSRecord(), "", null);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                OpSupportModelVariable opSupportModelVariable = this;
                timeSeriesContainer = opSupportModelVariable.buildOverrideTimeSeriesContainer(opSupportModelVariable._rawTS, "", null);
            }
        }
        return timeSeriesContainer;
    }

    private void addPlotObj(List<OpSupportPlotLine> list, TSRecord object, String string, String string2, int n, G2dLineProperties g2dLineProperties, String string3) {
        if (object == null) {
            return;
        }
        string2 = object.getTimeSeriesContainer();
        if (string3 != null) {
            ((TimeSeriesContainer)string2).location = string3;
        }
        ((TimeSeriesContainer)string2).version = string;
        ((TimeSeriesContainer)string2).parameter = object.getParamName();
        ((TimeSeriesContainer)string2).units = object.getUnits();
        if (this.a != null) {
            object = this.a.getOsConfig().getRssRun().getRunTimeWindow();
            boolean bl = object.isPerAvgTimeStep();
            ((TimeSeriesContainer)string2).type = bl && !((TimeSeriesContainer)string2).parameter.toUpperCase().startsWith("ELEV") && !((TimeSeriesContainer)string2).parameter.toUpperCase().startsWith("STOR") ? TSTYPE_PER_AVER : TSTYPE_INST_VAL;
            ((TimeSeriesContainer)string2).interval = object.getTimeStepMinutes();
        }
        object = new OpSupportTimeSeriesDataSet((TimeSeriesContainer)string2);
        ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMaxYValue(Double.NEGATIVE_INFINITY);
        ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYValue(Double.NEGATIVE_INFINITY);
        ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYRangeFac(0.01);
        list.add(new OpSupportPlotLine(n, (G2dObject)object, g2dLineProperties));
    }

    private TimeSeriesContainer buildTimeSeriesContainer(TSRecord tSRecord, String string, String string2) {
        if (tSRecord == null) {
            return null;
        }
        TimeSeriesContainer timeSeriesContainer = tSRecord.getTimeSeriesContainer();
        tSRecord.getTimeSeriesContainer().version = string;
        timeSeriesContainer.parameter = tSRecord.getParamName();
        if (string2 != null && string2.length() > 0) {
            timeSeriesContainer.parameter = timeSeriesContainer.parameter + "-" + string2;
        }
        timeSeriesContainer.units = tSRecord.getUnits();
        if (this.a != null) {
            tSRecord = this.a.getOsConfig().getRssRun().getRunTimeWindow();
            boolean bl = tSRecord.isPerAvgTimeStep();
            timeSeriesContainer.type = bl && !timeSeriesContainer.parameter.toUpperCase().startsWith("ELEV") && !timeSeriesContainer.parameter.toUpperCase().startsWith("STOR") ? TSTYPE_PER_AVER : TSTYPE_INST_VAL;
            timeSeriesContainer.interval = tSRecord.getTimeStepMinutes();
        }
        tSRecord = ServiceLookup.getTimeZoneDisplayService();
        timeSeriesContainer.timeZoneID = tSRecord.getTimeZone().getID();
        timeSeriesContainer.timeZoneRawOffset = tSRecord.getTimeZone().getRawOffset();
        return timeSeriesContainer;
    }

    private TimeSeriesContainer buildOverrideTimeSeriesContainer(OSVariableTSRef oSVariableTSRef, String string, String string2) {
        if (oSVariableTSRef == null) {
            return null;
        }
        TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
        RssRun rssRun = this.a.getOsConfig().getRssRun();
        rssRun = rssRun.getRunTimeWindow();
        rssRun.getNumSteps();
        timeSeriesContainer.times = oSVariableTSRef.getHECMinutes();
        if (timeSeriesContainer.times == null) {
            return null;
        }
        timeSeriesContainer.values = oSVariableTSRef.getOvrdValues();
        timeSeriesContainer.numberValues = timeSeriesContainer.times.length;
        timeSeriesContainer.startTime = timeSeriesContainer.times[0];
        timeSeriesContainer.endTime = timeSeriesContainer.times[timeSeriesContainer.numberValues - 1];
        timeSeriesContainer.version = string;
        if (this._varType == 4) {
            timeSeriesContainer.parameter = "Elev";
            if (string2 != null && string2.length() > 0) {
                timeSeriesContainer.parameter = timeSeriesContainer.parameter + "-" + string2;
            }
            timeSeriesContainer.units = "ft";
        } else {
            timeSeriesContainer.parameter = "Flow";
            if (string2 != null && string2.length() > 0) {
                timeSeriesContainer.parameter = timeSeriesContainer.parameter + "-" + string2;
            }
            timeSeriesContainer.units = "cfs";
        }
        boolean bl = rssRun.isPerAvgTimeStep();
        timeSeriesContainer.type = bl && this._varType != 4 ? TSTYPE_PER_AVER : TSTYPE_INST_VAL;
        timeSeriesContainer.interval = rssRun.getTimeStepMinutes();
        TimeZoneDisplayService timeZoneDisplayService = ServiceLookup.getTimeZoneDisplayService();
        timeSeriesContainer.timeZoneID = timeZoneDisplayService.getTimeZone().getID();
        timeSeriesContainer.timeZoneRawOffset = timeZoneDisplayService.getTimeZone().getRawOffset();
        return timeSeriesContainer;
    }

    private void addLimitPlotObj(List<OpSupportPlotLine> list, TSRecord tSRecord, String string, String string2, int n) {
        G2dLineProperties g2dLineProperties;
        Object object;
        if (tSRecord == null) {
            return;
        }
        if (RMAConst.isValidValue((double)this._maxLimit) && this._maxLimit != 0.0) {
            object = tSRecord.getTimeSeriesContainer();
            tSRecord.getTimeSeriesContainer().values = new double[((TimeSeriesContainer)object).values.length];
            Arrays.fill(((TimeSeriesContainer)object).values, this._maxLimit);
            ((TimeSeriesContainer)object).version = string;
            ((TimeSeriesContainer)object).parameter = tSRecord.getParamName();
            if (string2 != null && string2.length() > 0) {
                ((TimeSeriesContainer)object).parameter = ((TimeSeriesContainer)object).parameter + "-" + string2;
            }
            ((TimeSeriesContainer)object).parameter = ((TimeSeriesContainer)object).parameter + "-MAX";
            ((TimeSeriesContainer)object).units = tSRecord.getUnits();
            object = new OpSupportTimeSeriesDataSet((TimeSeriesContainer)object);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMaxYValue(Double.NEGATIVE_INFINITY);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYValue(Double.NEGATIVE_INFINITY);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYRangeFac(0.01);
            g2dLineProperties = new G2dLineProperties();
            new G2dLineProperties()._fillType = 1;
            g2dLineProperties._fillPattern = 4;
            g2dLineProperties._lineColor = Color.red.brighter();
            g2dLineProperties._fillColor = Color.red.brighter();
            list.add(new OpSupportPlotLine(n, (G2dObject)object, g2dLineProperties));
        }
        if (RMAConst.isValidValue((double)this._minLimit) && this._minLimit != 0.0) {
            object = tSRecord.getTimeSeriesContainer();
            tSRecord.getTimeSeriesContainer().values = new double[((TimeSeriesContainer)object).values.length];
            Arrays.fill(((TimeSeriesContainer)object).values, this._minLimit);
            ((TimeSeriesContainer)object).version = string;
            ((TimeSeriesContainer)object).parameter = tSRecord.getParamName();
            if (string2 != null && string2.length() > 0) {
                ((TimeSeriesContainer)object).parameter = ((TimeSeriesContainer)object).parameter + "-" + string2;
            }
            ((TimeSeriesContainer)object).parameter = ((TimeSeriesContainer)object).parameter + "-MIN";
            ((TimeSeriesContainer)object).units = tSRecord.getUnits();
            object = new OpSupportTimeSeriesDataSet((TimeSeriesContainer)object);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMaxYValue(Double.NEGATIVE_INFINITY);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYValue(Double.NEGATIVE_INFINITY);
            ((OpSupportTimeSeriesDataSet)((Object)object)).setDefaultMinYRangeFac(0.01);
            g2dLineProperties = new G2dLineProperties();
            new G2dLineProperties()._fillType = 2;
            g2dLineProperties._fillPattern = 4;
            g2dLineProperties._lineColor = Color.magenta.brighter();
            g2dLineProperties._fillColor = Color.magenta.brighter();
            list.add(new OpSupportPlotLine(n, (G2dObject)object, g2dLineProperties));
        }
    }

    public void initCompute(RssRun rssRun) {
        if (rssRun == null) {
            return;
        }
        RssSystem rssSystem = rssRun.getAlternative().getSystem();
        if (rssSystem == null) {
            return;
        }
        if (this._observedTS != null) {
            this._observedTS.initCompute(rssRun, this.a, 2);
        }
        if (this._rawTS != null) {
            if (this._varType == 1) {
                this._rawTS.initCompute(rssRun, this.a, 0);
            } else if (this._varType == 2 || this._varType == 4 || this._varType == 6) {
                this._rawTS.initCompute(rssRun, this.a, 1);
            }
        }
        if (this._editableTS != null) {
            this._editableTS.initCompute(rssRun, this.a, 0);
        }
        if (this._computedTS != null) {
            this._computedTS.initCompute(rssRun, this.a, 1);
        }
        if (this._overrideTS != null) {
            this._overrideTS.initCompute(rssRun, this.a, 1);
        }
        if (this._inflowTS != null) {
            this._inflowTS.initCompute(rssRun, this.a, 1);
        }
        if (this._supportingTSRefList != null) {
            for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                oSVariableTSRef.initCompute(rssRun, this.a, 1);
            }
        }
    }

    public double getValue(int n) {
        if (this._timeShiftSteps != 0) {
            n += this._timeShiftSteps;
        }
        switch (this._varType) {
            case 1: {
                if (this._editableTS == null) {
                    return -901.0;
                }
                return this._editableTS.getValue(n);
            }
            case 2: 
            case 4: 
            case 6: {
                double d = -901.0;
                if (this._overrideTS != null) {
                    d = this._overrideTS.getValue(n);
                }
                if (d == -901.0 && this._computedTS != null) {
                    d = this._computedTS.getValue(n);
                }
                return d;
            }
            case 3: {
                if (this._computedTS == null) {
                    return -901.0;
                }
                return this._computedTS.getValue(n);
            }
        }
        if (this._editableTS == null) {
            return -901.0;
        }
        return this._editableTS.getValue(n);
    }

    private void concatDrawProp(OsiTableProperty osiTableProperty, OsiTableProperty osiTableProperty2) {
        if (osiTableProperty == null || osiTableProperty2 == null) {
            return;
        }
        if (osiTableProperty2.usingFgColor()) {
            osiTableProperty.setUseFgColor(true);
            osiTableProperty.setFgcolor(osiTableProperty2.getFgcolor());
        }
        if (osiTableProperty2.usingBgColor()) {
            osiTableProperty.setUseBgColor(true);
            osiTableProperty.setBgcolor(osiTableProperty2.getBgcolor());
        }
        if (osiTableProperty2.usingFont()) {
            osiTableProperty.setUseFont(true);
            osiTableProperty.setFontName(osiTableProperty2.getFontName());
        }
        if (osiTableProperty2.usingBold()) {
            osiTableProperty.setUseBold(true);
            osiTableProperty.setBold(osiTableProperty2.isBold());
        }
        if (osiTableProperty2.usingItalic()) {
            osiTableProperty.setUseItalic(true);
            osiTableProperty.setItalics(osiTableProperty2.isItalics());
        }
    }

    public int getDisplayedValueProperties(int n, OsiTableProperties object, OsiTableProperty osiTableProperty) {
        if (object == null || osiTableProperty == null) {
            return -1;
        }
        if (this._timeShiftSteps != 0) {
            n += this._timeShiftSteps;
        }
        osiTableProperty.clear();
        object = ((OsiTableProperties)object).getTableProperties();
        int n2 = object.size() - 1;
        double d = -901.0;
        if (this._editableTS != null) {
            d = this._editableTS.getValue(n);
        }
        double d2 = -901.0;
        if (this._overrideTS != null) {
            d2 = this._overrideTS.getValue(n);
        }
        double d3 = -901.0;
        if (this._observedTS != null) {
            d3 = this._observedTS.getValue(n);
        }
        double d4 = -901.0;
        if (this._computedTS != null) {
            d4 = this._computedTS.getValue(n);
        }
        block12: for (int i = n2; i >= 0; --i) {
            OsiTableProperty osiTableProperty2 = (OsiTableProperty)object.get(i);
            switch (osiTableProperty2.getType()) {
                case 0: {
                    if (!RMAConst.isValidValue((double)d3)) continue block12;
                    if (RMAConst.isValidValue((double)d2)) {
                        if (!(Math.abs(d2 - d3) < 1.0E-6)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        if (!(Math.abs(d - d3) < 1.0E-6)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!RMAConst.isValidValue((double)d4) || !(Math.abs(d4 - d3) < 1.0E-6)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 1: {
                    if ((this.a.getOsConfig().getProtectLookback() || this._varType == 4 || this._varType == 2 || this._varType == 6) && this.a.getOsConfig().stepIsInLookback(n) || this._varType == 3) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 2: {
                    if (this._varType == 3) {
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!this.a.getOsConfig().getProtectLookback() || !this.a.getOsConfig().stepIsInLookback(n)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 3: {
                    if (d2 == -901.0) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 10: {
                    if (!RMAConst.isValidValue((double)this._minLimit)) continue block12;
                    if (RMAConst.isValidValue((double)d2)) {
                        if (!(d2 < this._minLimit)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        if (!(d < this._minLimit)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!RMAConst.isValidValue((double)d4) || !(d4 < this._minLimit)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 11: {
                    if (!RMAConst.isValidValue((double)this._maxLimit)) continue block12;
                    if (RMAConst.isValidValue((double)d2)) {
                        if (!(d2 > this._maxLimit)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        if (!(d > this._maxLimit)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!RMAConst.isValidValue((double)d4) || !(d4 > this._maxLimit)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 12: {
                    if (RMAConst.isValidValue((double)d2) || RMAConst.isValidValue((double)d)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 13: {
                    if (RMAConst.isValidValue((double)d2)) {
                        if (!this._overrideTS.isLargest(d2)) continue block12;
                        if (RMAConst.isValidValue((double)d)) {
                            if (!this._editableTS.isLargest(d2)) continue block12;
                            this.concatDrawProp(osiTableProperty, osiTableProperty2);
                            continue block12;
                        }
                        if (RMAConst.isValidValue((double)d4)) {
                            if (!this._computedTS.isLargest(d2)) continue block12;
                            this.concatDrawProp(osiTableProperty, osiTableProperty2);
                            continue block12;
                        }
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        if (!this._editableTS.isLargest(d)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!RMAConst.isValidValue((double)d4) || !this._computedTS.isLargest(d4)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 14: {
                    if (RMAConst.isValidValue((double)d2)) {
                        if (!this._overrideTS.isSmallest(d2)) continue block12;
                        if (RMAConst.isValidValue((double)d)) {
                            if (!this._editableTS.isSmallest(d2)) continue block12;
                            this.concatDrawProp(osiTableProperty, osiTableProperty2);
                            continue block12;
                        }
                        if (RMAConst.isValidValue((double)d4)) {
                            if (!this._computedTS.isSmallest(d2)) continue block12;
                            this.concatDrawProp(osiTableProperty, osiTableProperty2);
                            continue block12;
                        }
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        if (!this._editableTS.isSmallest(d)) continue block12;
                        this.concatDrawProp(osiTableProperty, osiTableProperty2);
                        continue block12;
                    }
                    if (!RMAConst.isValidValue((double)d4) || !this._computedTS.isSmallest(d4)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                    continue block12;
                }
                case 15: {
                    if (!this.a.getOsConfig().stepIsInLookback(n)) continue block12;
                    this.concatDrawProp(osiTableProperty, osiTableProperty2);
                }
            }
        }
        return 0;
    }

    public void setValue(int n, double d) {
        if (this._timeShiftSteps != 0) {
            n += this._timeShiftSteps;
        }
        switch (this._varType) {
            case 2: 
            case 4: 
            case 6: {
                if (this._overrideTS == null) {
                    return;
                }
                this._overrideTS.setValue(n, d);
                return;
            }
        }
        if (this._editableTS == null) {
            return;
        }
        this._editableTS.setValue(n, d);
    }

    public boolean saveData() {
        switch (this._varType) {
            case 2: 
            case 4: 
            case 6: {
                if (this._overrideTS == null) {
                    return true;
                }
                return this._overrideTS.saveData();
            }
        }
        if (this._editableTS == null) {
            return true;
        }
        return this._editableTS.saveData();
    }

    public void refreshData() {
        if (this._observedTS != null) {
            this._observedTS.refreshData();
        }
        if (this._editableTS != null) {
            this._editableTS.refreshData();
        }
        if (this._rawTS != null) {
            this._rawTS.refreshData();
        }
        if (this._computedTS != null) {
            this._computedTS.refreshData();
        }
        if (this._overrideTS != null) {
            this._overrideTS.refreshData();
        }
        if (this._inflowTS != null) {
            this._inflowTS.refreshData();
        }
        if (this._supportingTSRefList != null) {
            for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                oSVariableTSRef.refreshData();
            }
        }
    }

    public void computeRecession(int n) {
        if (this.a == null) {
            return;
        }
        RunTimeWindow runTimeWindow = this.a.getOsConfig().getRssRun().getRunTimeWindow();
        if (runTimeWindow == null) {
            return;
        }
        int n2 = runTimeWindow.getTimeStepMinutes();
        switch (this._varType) {
            case 2: 
            case 6: {
                if (this._overrideTS == null) {
                    return;
                }
                this._overrideTS.computeRecession(n, this._recessionConst, this._recessionMethod, n2, this._maxRecessPeriod);
                return;
            }
        }
        if (this._editableTS == null) {
            return;
        }
        this._editableTS.computeRecession(n, this._recessionConst, this._recessionMethod, n2, this._maxRecessPeriod);
    }

    public void setByIndependentVariable(int n, IndependentVariable independentVariable) {
        switch (n) {
            case 0: {
                if (this._observedTS == null) break;
                this._observedTS.setByIndependentVariable(independentVariable);
                return;
            }
            case 1: {
                if (this._editableTS == null) break;
                this._editableTS.setByIndependentVariable(independentVariable);
                return;
            }
            case 2: {
                if (this._computedTS == null) break;
                this._computedTS.setByIndependentVariable(independentVariable);
                return;
            }
            case 3: {
                if (this._overrideTS == null) break;
                this._overrideTS.setByIndependentVariable(independentVariable);
                return;
            }
            case 4: {
                if (this._inflowTS == null) break;
                this._inflowTS.setByIndependentVariable(independentVariable);
            }
        }
    }

    public IndependentVariable getAsIndependentVariable(int n) {
        if (this.a == null) {
            return null;
        }
        RssSystem rssSystem = this.a.getOsConfig().getRssSystem();
        switch (n) {
            case 0: {
                if (this._observedTS != null) {
                    return this._observedTS.getAsIndependentVariable(rssSystem);
                }
            }
            case 1: {
                if (this._editableTS != null) {
                    return this._editableTS.getAsIndependentVariable(rssSystem);
                }
            }
            case 2: {
                if (this._computedTS != null) {
                    return this._computedTS.getAsIndependentVariable(rssSystem);
                }
            }
            case 3: {
                if (this._overrideTS != null) {
                    return this._overrideTS.getAsIndependentVariable(rssSystem);
                }
            }
            case 4: {
                if (this._inflowTS == null) break;
                return this._inflowTS.getAsIndependentVariable(rssSystem);
            }
        }
        return null;
    }

    public Element getElement(int n) {
        if (this.a == null) {
            return null;
        }
        RssSystem rssSystem = this.a.getOsConfig().getRssSystem();
        int n2 = -1;
        switch (n) {
            case 0: {
                if (this._observedTS == null) break;
                n2 = this._observedTS.getElementID();
                break;
            }
            case 1: {
                if (this._editableTS == null) break;
                n2 = this._editableTS.getElementID();
                break;
            }
            case 2: {
                if (this._computedTS == null) break;
                n2 = this._computedTS.getElementID();
                break;
            }
            case 3: {
                if (this._overrideTS == null) break;
                n2 = this._overrideTS.getElementID();
                break;
            }
            case 4: {
                if (this._inflowTS == null) break;
                n2 = this._inflowTS.getElementID();
                break;
            }
            default: {
                return null;
            }
        }
        Element element = rssSystem.findElement(n2);
        return element;
    }

    public void setTabConfig(OpSupportTabConfig opSupportTabConfig) {
        this.a = opSupportTabConfig;
    }

    public void setToObs(int n) {
        switch (this._varType) {
            case 2: 
            case 4: 
            case 6: {
                if (this._overrideTS == null) {
                    return;
                }
                this._overrideTS.setToObs(n, this._observedTS);
                return;
            }
        }
        if (this._editableTS == null) {
            return;
        }
        this._editableTS.setToObs(n, this._observedTS);
    }

    public void calcLocal(int n) {
        switch (this._varType) {
            case 1: {
                if (this._editableTS == null) {
                    return;
                }
                this._editableTS.calcLocal(n, this._observedTS, this._computedTS);
            }
        }
    }

    public void clearTimeSeries(int n, int n2) {
        switch (this._varType) {
            case 2: 
            case 4: 
            case 6: {
                if (this._overrideTS == null) {
                    return;
                }
                this._overrideTS.clearTimeSeries(n, n2);
                return;
            }
        }
        if (this._editableTS == null) {
            return;
        }
        this._editableTS.clearTimeSeries(n, n2);
    }

    public void setMaxLimit(double d) {
        this._maxLimit = d;
    }

    public void setMinLimit(double d) {
        this._minLimit = d;
    }

    public double getMaxLimit() {
        return this._maxLimit;
    }

    public double getMinLimit() {
        return this._minLimit;
    }

    public static int getTypeIDbyName(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        int n = OPVAR_TYPE_STRARRAY.length;
        for (int i = 0; i < n; ++i) {
            if (!OPVAR_TYPE_STRARRAY[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public List<OSVariableTSRef> getSupportingTSRefList() {
        if (this._supportingTSRefList == null) {
            this._supportingTSRefList = new ArrayList<OSVariableTSRef>();
        }
        return this._supportingTSRefList;
    }

    public double getMaxRecessionPeriod() {
        return this._maxRecessPeriod;
    }

    public void setMaxRecessionPeriod(double d) {
        this._maxRecessPeriod = d;
    }

    public void setViewport(int n) {
        this._viewport = n;
    }

    public int getViewport() {
        return this._viewport;
    }

    public Vector getActiveTSProxies(Vector vector, int n, RssAlt rssAlt) {
        if (this._supportingTSRefList != null) {
            for (OSVariableTSRef oSVariableTSRef : this._supportingTSRefList) {
                vector = oSVariableTSRef.getActiveTSProxies(vector, n, rssAlt);
            }
        }
        return vector;
    }
}

